/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.common.blocks.entity;

import com.yollo.dmlreforged.common.blocks.entity.InventoryBlockEntity;
import com.yollo.dmlreforged.common.energy.DeepEnergyStorage;
import com.yollo.dmlreforged.common.items.ItemDataModel;
import com.yollo.dmlreforged.common.items.ItemLivingMatter;
import com.yollo.dmlreforged.common.items.ItemPristineMatter;
import com.yollo.dmlreforged.common.mobmetas.MobMetaData;
import com.yollo.dmlreforged.common.mobmetas.MobMetaFactory;
import com.yollo.dmlreforged.core.init.BlockEntityInit;
import com.yollo.dmlreforged.core.init.ItemInit;
import com.yollo.dmlreforged.core.util.DataModelHelper;
import com.yollo.dmlreforged.core.util.MathHelper;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class BlockEntitySimulationChamber
extends InventoryBlockEntity {
    public static final int DATA_MODEL_SLOT = 0;
    public static final int POLYMER_SLOT = 1;
    public static final int LIVING_SLOT = 2;
    public static final int PRISTINE_SLOT = 3;
    public int percentDone = 0;
    public DeepEnergyStorage energyStorage = this.createEnergyStorage();
    public int ticks = 0;
    private boolean isCrafting;
    private boolean byproductSuccess = false;
    private LazyOptional<DeepEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    private String currentDataModelType = "";
    private MobMetaData mobMetaData;
    private static Integer[] bannSlot = new Integer[]{0, 1};

    public BlockEntitySimulationChamber(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.ENTITY_SIMULATION_CHAMBER.get(), pWorldPosition, pBlockState, 4, bannSlot);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.energy.invalidate();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("energy", this.energyStorage.getEnergyStored());
        tag.m_128405_("simulationProgress", this.percentDone);
        tag.m_128379_("isCrafting", this.isCrafting);
        tag.m_128379_("craftSuccess", this.byproductSuccess);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.energyStorage.setEnergy(pTag.m_128441_("energy") ? pTag.m_128451_("energy") : 300000);
        this.percentDone = pTag.m_128441_("simulationProgress") ? pTag.m_128451_("simulationProgress") : 0;
        this.isCrafting = pTag.m_128441_("isCrafting") ? pTag.m_128471_("isCrafting") : this.isCrafting;
        this.byproductSuccess = pTag.m_128441_("craftSuccess") ? pTag.m_128471_("craftSuccess") : this.isCrafting;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return cap == CapabilityEnergy.ENERGY ? this.energy.cast() : super.getCapability(cap, side);
    }

    private DeepEnergyStorage createEnergyStorage() {
        return new DeepEnergyStorage(this, 2000000, 25600, 0, 0);
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    public int getProgress() {
        return this.percentDone;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public void tick(Level pLevel, BlockEntitySimulationChamber be) {
        ++this.ticks;
        if (!pLevel.f_46443_) {
            if (!this.isCrafting()) {
                if (this.canStartSimulation()) {
                    this.startSimulation(be);
                }
            } else {
                if (!this.canContinueSimulation() || this.dataModelTypeChanged()) {
                    this.finishSimulation(true, pLevel, be);
                    return;
                }
                if (this.percentDone == 0) {
                    int chance;
                    Random rand = new Random();
                    int num = rand.nextInt(100);
                    this.byproductSuccess = num <= MathHelper.ensureRange(chance = DataModelHelper.getPristineChance(this.getDataModel()), 1, 100);
                }
                int rfTickCost = this.mobMetaData.getSimulationTickCost();
                this.energyStorage.setEnergy(this.energyStorage.getEnergyStored() - rfTickCost);
                if (this.ticks % 3 == 0) {
                    ++this.percentDone;
                }
                if (this.ticks % 40 == 0) {
                    this.update();
                }
            }
            if (this.percentDone == 100) {
                System.out.println("done");
                this.finishSimulation(false, pLevel, be);
                return;
            }
        }
    }

    private void startSimulation(BlockEntitySimulationChamber be) {
        this.isCrafting = true;
        this.currentDataModelType = DataModelHelper.getMobMetaData(this.getDataModel()).getKey();
        this.mobMetaData = MobMetaFactory.createMobMetaData(this.currentDataModelType);
        ItemStack oldInput = this.getPolymerClay();
        ItemStack newInput = new ItemStack((ItemLike)ItemInit.POLYEMR_CLAY.get(), oldInput.m_41613_() - 1);
        this.inventory.setStackInSlot(1, newInput);
    }

    private void finishSimulation(boolean abort, Level world, BlockEntitySimulationChamber be) {
        this.percentDone = 0;
        this.isCrafting = false;
        if (!abort && !world.f_46443_) {
            DataModelHelper.increaseSimulationCount(this.getDataModel());
            ItemStack oldOutput = this.getLiving();
            ItemStack newOutput = this.mobMetaData.getLivingMatterStack(oldOutput.m_41613_() + 1);
            this.inventory.setStackInSlot(2, newOutput);
            if (this.byproductSuccess) {
                this.byproductSuccess = false;
                ItemStack oldPristine = this.getPristine();
                ItemStack newPristine = this.mobMetaData.getPristineMatterStack(oldPristine.m_41613_() + 1);
                this.inventory.setStackInSlot(3, newPristine);
            }
            this.update();
        }
    }

    private boolean canStartSimulation() {
        return this.hasEnergyForSimulation() && this.canContinueSimulation() && !this.outputIsFull() && !this.pristineIsFull() && this.hasPolymerClay();
    }

    private boolean canContinueSimulation() {
        return this.hasDataModel() && DataModelHelper.getTier(this.getDataModel()) != 0;
    }

    private boolean dataModelTypeChanged() {
        return !this.currentDataModelType.equals(DataModelHelper.getMobMetaData(this.getDataModel()).getKey());
    }

    public boolean hasEnergyForSimulation() {
        if (this.hasDataModel()) {
            int ticksPerSimulation = 300;
            return this.energyStorage.getEnergyStored() > ticksPerSimulation * DataModelHelper.getSimulationTickCost(this.getDataModel());
        }
        return false;
    }

    public ItemStack getDataModel() {
        return this.inventory.getStackInSlot(0);
    }

    private ItemStack getPolymerClay() {
        return this.inventory.getStackInSlot(1);
    }

    private ItemStack getLiving() {
        return this.inventory.getStackInSlot(2);
    }

    private ItemStack getPristine() {
        return this.inventory.getStackInSlot(3);
    }

    public boolean hasPolymerClay() {
        ItemStack stack = this.getPolymerClay();
        return stack.m_41720_() == ItemInit.POLYEMR_CLAY.get() && stack.m_41613_() > 0;
    }

    public boolean hasDataModel() {
        return this.getDataModel().m_41720_() instanceof ItemDataModel;
    }

    public boolean outputIsFull() {
        ItemStack stack = this.getLiving();
        if (stack.m_41619_()) {
            return false;
        }
        boolean stackLimitReached = stack.m_41613_() == this.inventory.getSlotLimit(2);
        boolean outputMatches = BlockEntitySimulationChamber.dataModelMatchesOutput(this.getDataModel(), this.getLiving());
        return stackLimitReached || !outputMatches;
    }

    public boolean pristineIsFull() {
        ItemStack stack = this.getPristine();
        if (stack.m_41619_()) {
            return false;
        }
        boolean stackLimitReached = stack.m_41613_() == this.inventory.getSlotLimit(1);
        boolean outputMatches = BlockEntitySimulationChamber.dataModelMatchesPristine(this.getDataModel(), this.getPristine());
        return stackLimitReached || !outputMatches;
    }

    public boolean getByproductSuccess() {
        return this.byproductSuccess;
    }

    private static boolean dataModelMatchesOutput(ItemStack stack, ItemStack output) {
        ItemLivingMatter livingMatter = DataModelHelper.getMobMetaData(stack).getLivingMatter();
        return ((Object)((Object)livingMatter)).getClass().equals(output.m_41720_().getClass());
    }

    private static boolean dataModelMatchesPristine(ItemStack stack, ItemStack pristine) {
        ItemPristineMatter pristineMatter = DataModelHelper.getMobMetaData(stack).getPristineMatter();
        return ((Object)((Object)pristineMatter)).getClass().equals(pristine.m_41720_().getClass());
    }
}

